<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;

Auth::routes();

//rutas front
Route::group(["namespace" => "front", "middleware" => ["web"]], function() {
	//home
	Route::get("/", "HomeController@index");
	Route::get("/quienes-somos/institucion", "QuinesSomosController@institucion");
	Route::get("/quienes-somos/instalaciones", "QuinesSomosController@instalaciones");
	Route::get("/servicios", "ServiciosController@servicios");
	Route::get("/juegos", "JuegosController@juegos");
	Route::get("/liga/sabatina/{grupo}/{jornada?}", "LigasController@sabatina");
	Route::get("/liga/dominical/{grupo}/{jornada?}", "LigasController@dominical");
	Route::get("/noticias", "NoticiasController@index");
	Route::get("/contacto", "ContactosController@index");
});


//rutas admin
Route::group(['namespace'=>'admin','prefix'=>'admin-morelos','middleware' => ['web', 'auth']], function () {
	Route::get('/', 'DashboardController@index');

	Route::get('/usuarios', 'UsuarioController@index');
	Route::get('/usuarios/crear', 'UsuarioController@crear');
	Route::get('/usuarios/editar/{id}', 'UsuarioController@editar');
	Route::post('/usuarios/guardar', 'UsuarioController@guardar');
	Route::put('/usuarios/eliminar/{id}', 'UsuarioController@eliminar');
	Route::put('/usuarios/actualizar/{id}', 'UsuarioController@actualizar')->name('usuarios.actualizar');
	Route::get('/usuarios/borrar/{id}', 'UsuarioController@borrar');
	Route::put('/usuarios/eliminar/{id}', 'UsuarioController@eliminar')->name('usuarios.eliminar');

	Route::get('/noticias', 'NoticiaController@index');
	Route::get('/noticias/crear', 'NoticiaController@crear');
	Route::post('/noticias/guardar', 'NoticiaController@guardar');
	Route::get('/noticias/editar/{id}', 'NoticiaController@editar');
	Route::put('/noticias/actualizar/{id}', 'NoticiaController@actualizar')->name('noticias.actualizar');
	Route::put('/noticias/eliminar/{id}', 'NoticiaController@eliminar')->name('noticias.eliminar');

	Route::get('/equipos', 'EquipoController@index');
	Route::get('/equipos/lista', 'EquipoController@lista');
	Route::get('/equipos/editar/{id}', 'EquipoController@editar');
	Route::get('/equipos/imprimirCredencial', 'EquipoController@imprimirCredencial');
	Route::get('/equipos/generateC/{id}', 'EquipoController@generarCredencial');
	Route::put('/equipos/actualizar/{id}', 'EquipoController@actualizar');
	Route::get('equipos/descargar/{time}', 'EquipoController@descargar');
	Route::get('equipos/marcar/{id}', 'EquipoController@marcar');
	Route::post('equipos/marcarCancelado', 'EquipoController@marcarCancelado');
	Route::get('equipos/multas', 'EquipoController@multas');

	Route::get('/jugadores', 'JugadorController@index');
	Route::get('/jugadores/lista', 'JugadorController@lista');
	Route::get('/jugadores/crear', 'JugadorController@crear');
	Route::post('/jugadores/guardar', 'JugadorController@guardar');
	Route::get('/jugadores/editar/{id}', 'JugadorController@editar');
	Route::get('/jugadores/solicitar/{id}', 'JugadorController@solicitar');
	Route::put('/jugadores/actualizar/{id}', 'JugadorController@actualizar')->name('jugadores.actualizar');
	Route::put('/jugadores/eliminar/{id}', 'JugadorController@eliminar')->name('jugadores.eliminar');
	Route::post('/jugadores/multar', 'JugadorController@multar');
});

//rutas admin
Route::group(['namespace'=>'admin','prefix'=>'admin-morelos','middleware' => ['web']], function () {
	Route::get('/equipos/generarCredencial/{id}', 'EquipoController@generarCredencial');
});
