@extends('layouts.master')

@section("contenido")
    <div class="rs-breadcrumbs">
        <div class="breadcrumbs-wrap">
            <img src="{{ Theme::asset('images/breadcrumbs/bg1.jpg', null, false) }}" alt="Breadcrumbs Image">
            <div class="breadcrumbs-inner">
                <div class="container">
                    <div class="breadcrumbs-text">
                        <h1 class="breadcrumbs-title mb-17">Noticias</h1>
                        <div class="categories">
                            <ul>
                                <li><a href="{{ url('/') }}">Inicio</a></li>
                                <li class="active">Noticias</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>                
    </div>

    <div class="rs-blog modify pt-100 md-pt-80 md-pb-80">
        <div class="container">
            <div class="pb-100 md-pb-80">
                <div class="row">
                    @if(count($noticias)>0)
                        @foreach($noticias as $n)
                            <div class="col-xl-3 col-lg-4 col-md-6 mb-30">
                                <div class="blog-item">
                                    <div class="blog-img">
                                        <div class="image-wrap">
                                            <a href="#">
                                                <img src="{{asset('storage/noticias/'.$n->id.'/'.$n->imagen)}}" alt="{{$n->titulo}}">
                                            </a>
                                        </div>
                                        <div class="all-meta">
                                            <div class="meta meta-date">
                                                <span class="month-day">{{ ucwords(strftime("%d", strtotime($n->fecha))) }}</span>
                                                <span class="month-name">{{ ucwords(strftime("%b", strtotime($n->fecha))) }}</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="blog-content">
                                        <h4 class="blog-title">
                                            <a href="#">{{$n->titulo}}</a>
                                        </h4>
                                        <div class="blog-desc">
                                            {!!trim(substr($n->descripcion, 0, 150))!!}...
                                        </div>
                                        <div class="read-button">
                                            <a href="#">Continuar Leyendo</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    @else
                        <h4>Sin Noticias</h4>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection