@extends('layouts.master')

@section("contenido")
    <div class="rs-breadcrumbs">
        <div class="breadcrumbs-wrap">
            <img src="{{ Theme::asset('images/breadcrumbs/bg1.jpg', null, false) }}" alt="Breadcrumbs Image">
            <div class="breadcrumbs-inner">
                <div class="container">
                    <div class="breadcrumbs-text">
                        <h1 class="breadcrumbs-title mb-17">Tabla de Posiciones Liga Dominical <br> Grupo {{ $grupo }}</h1>
                        <div class="categories">
                            <ul>
                                <li><a href="{{ url('/') }}">Inicio</a></li>
                                <li class="active">Tabla de Posiciones Liga Dominical Grupo {{ $grupo }}</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>                
    </div>

    <div class="rs-pointtable inner-style pt-100 md-pt-80 md-pb-80">
        <div class="container">
            <div class="col-md-8 offset-md-2">
                <h3 style="margin-bottom: 0">
                    Jornada {{ $jornada + 1 }}
                    <span class="float-right">
                        @if($jornada > 0)
                            <?php
                                $jor = $jornada - 1;
                            ?>
                            <a href="{{ url('/liga/dominical/'.$grupo.'/'.$jor) }}" style="font-size: 12px">Anterior</a>
                        @endif
                        @if($jornada < 21)
                            <?php
                                $jor = $jornada + 1;
                            ?>
                            <a href="{{ url('/liga/dominical/'.$grupo.'/'.$jor) }}" style="font-size: 12px">Siguiente</a>
                        @endif
                    </span>
                </h3>
                <table>
                    <tbody>
                        @if(count($juegosDominical)>0)
                            @for($i= 0; $i < count($juegosDominical); $i++)
                                @if( ( $i % 2 ) != 0 )
                                    <?php continue; ?>
                                @endif
                                <tr>
                                    <td class="medium-font text-right">
                                        {{ $juegosDominical[$i]->nombre }} <span class="badge badge-secondary">{{ $juegosDominical[$i]->resultado }}</span>
                                    </td>
                                    <td class="short-width">VS</td>
                                    <td class="medium-font">
                                        <span class="badge badge-secondary">{{ $juegosDominical[$i + 1]->resultado }}</span> {{ $juegosDominical[$i + 1]->nombre }}
                                    </td>
                                    <td>
                                        {{ $juegosDominical[$i]->fecha }}, {{ $juegosDominical[$i]->hora }}
                                    </td>
                                    <td>
                                        Cancha: {{ $juegosDominical[$i]->cancha }}
                                    </td>
                                </tr>
                            @endfor
                        @endif
                    </tbody>
                </table>

                <br><br>
                <h3>Jugadores Multados para esta jornada</h3>
                <table>
                    <thead>
                        <tr style="color: #fff; background-color: #212529; border-color: #32383e;">
                            <td>Equipo</td>
                            <td>Jugador</td>
                        </tr>
                    </thead>
                    <tbody>
                        @if(count($multas)>0)
                            @foreach($multas as $m)
                                <tr>
                                    <td>{{$m->equipo}}</td>
                                    <td>{{$m->nombres}} {{$m->apellidos}}</td>
                                </tr>
                            @endforeach
                        @else
                            <tr>
                                <td colspan="2">Sin Registros</td>
                            </tr>
                        @endif
                    </tbody>
                </table>
            </div>
    

            <div class="point-table-wrap mt-5 pb-100 md-pb-80">
                <table>
                    <thead>
                        <tr>
                            <th class="gb-naranja">#</th>
                            <th class="gb-naranja">Equipo</th>
                            <th colspan="4" class="gb-azul">Partidos</th>
                            <th colspan="3" class="gb-verde">Goles</th>
                            <th class="gb-morado">Tot</th>
                        </tr>
                        <tr>
                            <th class="gb-naranja">Lug</th>
                            <th class="gb-naranja">Nombre</th>
                            <th class="gb-azul">PJ</th>
                            <th class="gb-azul">PG</th>
                            <th class="gb-azul">PE</th>
                            <th class="gb-azul">PP</th>
                            <th class="gb-verde">GF</th>
                            <th class="gb-verde">GC</th>
                            <th class="gb-verde">Dif</th>
                            <th class="gb-morado">Pts</th>
                        </tr>
                    </thead>
                    <tbody>
                        @if (count($posiciones)>0)
                            @foreach ($posiciones as $key => $p)
                                <tr>
                                    <td class="gb-naranja">{{ $key + 1 }}</td>
                                    <td class="gb-naranja">{{ $p->nombreEquipo }}</td>
                                    <td class="gb-azul">{{ $p->jj }}</td>
                                    <td class="gb-azul">{{ $p->jg }}</td>
                                    <td class="gb-azul">{{ $p->je }}</td>
                                    <td class="gb-azul">{{ $p->jp }}</td>
                                    <td class="gb-verde">{{ $p->gf }}</td>
                                    <td class="gb-verde">{{ $p->gc }}</td>
                                    <td class="gb-verde">{{ $p->gf - $p->gc }}</td>
                                    <td class="gb-morado">{{ $p->suma }}</td>
                                </tr>
                            @endforeach 
                        @endif
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection