@extends('layouts.admin')
@section("content")
<div class="row">
	<div class="col-md-12">
		<div class="card">
			<div class="card-block">
				<div class="row">
					<div class="col-md-12">
						<h4 class="card-title">Noticias</h4>
					</div>
				</div>
				@include('messages.messages')
				<div class="row">
					<div class="col-md-12">
						{!! Form::open(['url' => 'admin-morelos/noticias/guardar', 'method' => 'post', 'class'=>'form-horizontal', 'enctype'=>'multipart/form-data']) !!}
							<div class="row">
								<div class="col-md-6">
									<div class="form-group row">
										<label class="col-md-12 control-label">Titulo</label>
										<div class="col-md-12">
											{{Form::text('titulo', NULL, ["class"=>"form-control", "required", "id"=>"titulo"])}}
										</div>
									</div>
								</div>
								<div class="col-md-6">
									<div class="form-group row">
										<label for="form-1-1" class="col-md-12 control-label">Slug</label>
										<div class="col-md-12">
											{{Form::text('slug', $host, ["class"=>"form-control", "required", "readonly", "id"=>"slug"])}}
										</div>
									</div>
								</div>
								<div class="col-md-6">
									<div class="form-group row">
										<label for="form-1-1" class="col-md-12 control-label">
											Meta Descripción (SEO)
										</label>
										<div class="col-md-12">
											{{Form::text('meta_descripcion', NULL, ["class"=>"form-control", "placeholder"=>"Opcional"])}}
										</div>
									</div>
								</div>
								<div class="col-md-6">
									<div class="form-group row">
										<label for="form-1-1" class="col-md-12 control-label">
											Meta Titulo (SEO)
										</label>
										<div class="col-md-12">
											{{Form::text('meta_titulo', NULL, ["class"=>"form-control", "placeholder"=>"Opcional"])}}
										</div>
									</div>
								</div>
								<div class="col-md-12">
									<div class="form-group row">
										<label for="form-1-1" class="col-md-12 control-label">
											Imagen Destacada
										</label>
										<div class="col-md-12">
											{{Form::file('imagen', ["class"=>"form-control", "required"])}}
										</div>
									</div>
								</div>
								<div class="col-md-12">
									<div class="card">
										<div class="card-block">
											<div class="row">
												<div class="col-md-12">
													<h4 class="card-title">Descripción</h4>
													{{Form::textarea('descripcion', NULL, ["class"=>"form-control", "id"=>"summernote-usage"])}}
												</div>
											</div>
										</div>
									</div>
								</div>
								
								<div class="col-md-12">
									<button type="submit" class="btn btn-success">
										<i class="ti-save pdd-right-5"></i>
										<span>Guardar</span>
									</button>
								</div>
							</div>
						{!! Form::close() !!}
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<script>
	setInterval(function(){
		$("#titulo").on("change", function(){
			var url = "<?php echo $host;?>";
			$('#slug').val(url+$("#titulo").val().trim().split(" ").join("-"));
		});
	}, 500);
</script>
@endsection