@extends('layouts.admin')
@section("content")
<div class="row">
	<div class="col-md-12">
		<div class="card">
			<div class="card-block">
				<div class="row">
					<div class="col-md-12">
						<h4 class="card-title">Equipos</h4>
					</div>
				</div>
				@include('messages.messages')
				<div class="row">
					<div class="col-md-12">
						 {!! Form::model($equipo, ['method' => 'PUT', 'url' => 'admin-morelos/equipos/actualizar/'.$equipo->id,'enctype'=>'multipart/form-data']) !!}
								<div class="row">
								<div class="col-md-4">
									<div class="form-group row">
										<label for="form-1-1" class="col-md-12 control-label">
											Nombre
										</label>
										<div class="col-md-12">
											{{Form::text('nombre', NULL, ["class"=>"form-control", "required"])}}
										</div>
									</div>
								</div>
								@foreach($logo as $l)
									<div class="col-md-4">
										<div class="form-group row">
											<label for="form-1-1" class="col-md-12 control-label">
												Logo Actual
											</label>
											<td>
												@if ($l->logo)
													<img src="{{asset('storage/equipos/'.$l->id.'/'.$l->logo)}}" height="40px">
												@else
													<img src="{{asset('themes/deportivo/images/balon.png')}}" alt="" height="40px">
												@endif
											</td>
										</div>
									</div>
								@endforeach
								<div class="col-md-4">
									<div class="form-group row">
										<label for="form-1-1" class="col-md-12 control-label">
											Actualizar Logo
										</label>
										<div class="col-md-12">
											{{Form::file('logo', ["class"=>"form-control"])}}
										</div>
									</div>
								</div>

								<div class="col-md-6">
									<div class="form-group row">
										<label for="form-1-1" class="col-md-12 control-label">
											Liga
										</label>
										<div class="col-md-12">
											{{Form::select('liga', ['1' => 'Sabatina', '2' => 'Dominical'], NULL,  ["required", "class"=>"form-control"])}}
										</div>
									</div>
								</div>
								<div class="col-md-6">
									<div class="form-group row">
										<label for="form-1-1" class="col-md-12 control-label">
											Grupo
										</label>
										<div class="col-md-12">
											{{Form::select('grupo', ['1'=>'1','2'=>'2','3'=>'3','4'=>'4','5'=>'5','6'=>'6'], NULL,  ["required", "class"=>"form-control"])}}
										</div>
									</div>
								</div>
								<div class="col-md-6">
									<div class="form-group row">
										<label for="form-1-1" class="col-md-12 control-label">
											Responsable
										</label>
										<div class="col-md-12">
											{{Form::select('responsable', $usuarios, $equipo->id_usuario,  ["required", "class"=>"form-control"])}}
										</div>
									</div>
								</div>
								
								<div class="col-md-12">
									<button type="submit" class="btn btn-success">
										<i class="ti-save pdd-right-5"></i>
										<span>Actualizar</span>
									</button>
								</div>
							</div>
						{!! Form::close() !!}
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

@endsection