@extends('layouts.admin')
@section("content")
<div class="row">
	<div class="col-md-12">
		<div class="card">
			<div class="card-block">
				<div class="row">
					<div class="col-md-6">
						<h4 class="card-title">Jugadores</h4>
					</div>
					<div class="col-md-6">
						<a href="{{url('admin-morelos/jugadores/crear')}}" class="btn btn-success pull-right">
							<i class="ti-plus pdd-right-5"></i>
							<span>Nuevo</span>
						</a>
					</div>
				</div>
				<div class="table-overflow">
					@include("messages.messages")
					<table class="table">
						<thead>
							<tr>
								<th>Foto</th>
								<th>Nombres</th>
								<th>Apellidos</th>
								<th>Identificación</th>
								<th>Motivo Rechazo</th>
								<th></th>
							</tr>
						</thead>
						<tbody>
							@if(count($jugadores)>0)
								@foreach($jugadores as $j)
									<tr>
										<td>
											<img src="{{asset('storage/jugadores/'.$j->id.'/'.$j->imagen)}}" height="40px">
										</td>
										<td>{{$j->nombres}}</td>
										<td>{{$j->apellidos}}</td>
										<td>{{$j->dni}}</td>
										<td>
											@if($j->motivoCancelado)
												<div class="alert alert-danger" role="alert">
												  	{{$j->motivoCancelado}}
												</div>
											@endif
										</td>
										<td>
											<div class="btn-group">
												<a href="{{url('admin-morelos/jugadores/editar')}}/{{$j->id}}" class="btn btn-info">
													<i class="ti-pencil"></i>
												</a>
											
												<a href="#" class="btn btn-danger"  onclick="$('#formDelete{{$j->id}}').submit()">
													<i class="ti-trash"></i>
												</a>

												@if ($j->estado === 0)
													<a href="{{url('admin-morelos/jugadores/solicitar/'.$j->id)}}" class="btn btn-success">
														<i class="ti-printer"></i>
													</a>
												@endif
											</div>
											{!! Form::open(['method' => 'PUT', 'id' => "formDelete$j->id", 'onsubmit' => "return confirm('".trans("Esta Seguro de Eliminar?")."');", 'url' => "admin-morelos/jugadores/eliminar/$j->id"]) !!}
											{!! Form::close() !!}

											</div>
										</td>
									</tr>
								@endforeach
							@else
								<tr>
									<td colspan="4">No hay registros</td>
								</tr>
							@endif
						</tbody>
					</table>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection