<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEquiposTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('equipos', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('id_usuario')->default(1);
            $table->unsignedBigInteger('idApi');
            $table->string('nombre');
            $table->string('logo')->nullable();
            $table->enum('liga', ['1','2']);
            $table->enum('grupo', ['1','2','3','4','5','6']);
            $table->enum('estado', ['D','E'])->default('D');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('equipos');
    }
}
