<?php

namespace App\Http\Controllers\Admin;

use DB;
use Auth;
use Theme;
use App\Noticia;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class NoticiaController extends Controller
{
	public function __construct()
    {
    	Theme::init("adminmorelos");
    }

	public function index()
	{
		$noticias=Noticia::orderBy('id', 'desc')->get();
		return view('noticias/lista')->with(compact('noticias'));
	}

	public function crear()
	{
		$protocol=(isset($_SERVER['HTTPS'])) ? "https://" : "http://";
		$host= $protocol.$_SERVER['HTTP_HOST']."/html/deportivo/public/";
		return view('noticias/crear')->with(compact('host'));
	}

	public function guardar(Request $request)
	{
		$noticia=new Noticia;
		$imagen=$request->file('imagen');
		$nombre_imagen=$imagen->getClientOriginalName();
		$noticia->id_usuario=1;//Auth()->user()->id;
		$noticia->titulo=$request->titulo;
		$noticia->slug=$request->slug;
		$noticia->descripcion=$request->descripcion;
		$noticia->meta_descripcion=$request->meta_descripcion;
		$noticia->meta_titulo=$request->meta_titulo;
		$noticia->fecha=date("Y-m-d");
		$noticia->imagen=$nombre_imagen;
		\DB::beginTransaction();
		try {
			if ($noticia->save()) {
				\Storage::disk('public')->put('noticias/'.$noticia->id."/".$nombre_imagen,  \File::get($imagen));
			}
			\DB::commit();
			return redirect()->back()->with("success", "Datos Guardados");
		} catch (\Illuminate\Database\QueryException $e) {
			\DB::rollback();
			if($e->getCode()==23000){
				return redirect()->back()->withInput()->with("error", "Slug duplicado");
			}else{
				return redirect()->back()->withInput()->with("error", "Ocurrio un error, intenta de nuevo, si el problema persiste contacta con el proveedor");
			}
		} catch (\Exception $ex){
			\DB::rollback();
			return redirect()->back()->withInput()->with("error", "Error al cargar imagen");
		}
	}


	public function editar($id)
	{
		$noticia = Noticia::findOrFail($id);
		$protocol=(isset($_SERVER['HTTPS'])) ? "https://" : "http://";
		$host= $protocol.$_SERVER['HTTP_HOST']."/html/deportivo/public/";

        $imagen = DB::table('noticias')
                    ->select('imagen','descripcion','id')
                    ->where('id','=',$id)
                    ->get();

		return view('noticias/editar')->with(compact('noticia','host','protocol','imagen'));
	}


	public function actualizar(Request $request,$id)
	{
		    if(! is_null($request->imagen)) {
		    $noticia = Noticia::findOrFail($id);
			$imagen=$request->file('imagen');
			$nombre_imagen=$imagen->getClientOriginalName();
			$noticia->id_usuario=1;//Auth()->user()->id;
			$noticia->titulo=$request->titulo;
			$noticia->slug=$request->slug;
			$noticia->descripcion=$request->descripcion;
			$noticia->meta_descripcion=$request->meta_descripcion;
			$noticia->meta_titulo=$request->meta_titulo;
			$noticia->fecha=date("Y-m-d");
			$noticia->imagen=$nombre_imagen;
		   
		\DB::beginTransaction();
		try {
			if ($noticia->update()) {
				\Storage::disk('public')->put('noticias/'.$noticia->id."/".$nombre_imagen,  \File::get($imagen));
			}
			\DB::commit();
			return redirect()->back()->with("success", "Datos Actualizados");
		} catch (\Illuminate\Database\QueryException $e) {
			\DB::rollback();
			if($e->getCode()==23000){
				return redirect()->back()->withInput()->with("error", "Slug duplicado");
			}else{
				return redirect()->back()->withInput()->with("error", "Ocurrio un error, intenta de nuevo, si el problema persiste contacta con el proveedor");
			}
		} catch (\Exception $ex){
			\DB::rollback();
			return redirect()->back()->withInput()->with("error", "Error al cargar imagen");
		}
	} else {

		$noticia = Noticia::findOrFail($id);
		$noticia->id_usuario=1;//Auth()->user()->id;
		$noticia->titulo=$request->titulo;
		$noticia->slug=$request->slug;
		$noticia->descripcion=$request->descripcion;
		$noticia->meta_descripcion=$request->meta_descripcion;
		$noticia->meta_titulo=$request->meta_titulo;
		$noticia->fecha=date("Y-m-d");
		$noticia->update();
		return redirect()->back()->with("success", "Datos Actualizados");


	}

		
	}

	public function borrar($id)
	{
		$noticia = Noticia::findOrFail($id);
        $imagen = DB::table('noticias')
                    ->select('imagen','descripcion','id')
                    ->where('id','=',$id)
                    ->get();

		return view('noticias/borrar')->with(compact('noticia','imagen'));
	}


	public function eliminar($id)
	{
		$noticia = Noticia::findOrFail($id);
		$noticia->delete();
		return redirect()->to('admin-morelos/noticias');
	}
}