<?php

namespace App\Http\Controllers;

use App\Juego;
use App\Equipo;
use App\Posicion;
use Illuminate\Http\Request;

class ApiController extends Controller
{
    public function recibirDatosAccess(Request $request)
    {
        ini_set('max_execution_time', 0);
        ini_set('memory_limit', -1);

    	$datos = json_decode(utf8_encode($request->getContent()));

    	foreach ($datos->dataEquipo as $key => $value) {
    		$data = [
    			"grupo"  => $value->grp,
    			"nombre" => $value->tmName,
    			"estado" => $value->status,
    			"liga"   => $value->day
    		]; 
    		$id = $value->idEquipo;
    		Equipo::cargaApi($id, $data);
    	}

        foreach ($datos->dataJuego as $key => $value) {
            $year = substr($value->fecha, 0, 4);
            $mes = substr($value->fecha, 4, 2);
            $dia = substr($value->fecha, 6, 2);
            $hora = substr($value->hora, 0, 2);
            $min  = substr($value->hora, 2, 4);

            $fecha = $year."-".$mes."-".$dia;
            $hr    = $hora.":".$min;

            $id = $value->idJuego;

            $data = [
                "equipo"    => $value->idEquipo,
                "cancha"    => $value->cancha,
                "fecha"     => $fecha,
                "liga"      => $value->liga,
                "grupo"     => $value->grupo,
                "hora"      => $hr,
                "resultado" => $value->resultado,
            ]; 
            Juego::cargaApi($id, $data);
        }

        $this->verificarPuntos();

        foreach ($datos->dataGiven as $key => $value) {
            $data = [
                "equipo"    => $value->idEquipo,
                "suma"      => $value->puntos,
            ]; 
            Posicion::cargaApi($value->idEquipo, $data);
        }
    }

    public function verificarPuntos()
    {
        Posicion::truncateTbPosicion();
        $juegos      = Juego::traerTodos();
        $grupoJuegos = [];
        $resultado   = [];

        foreach ($juegos as $key => $value) {
            $codigoUnico = $value->cancha.$value->fecha.$value->hora.$value->grupo.$value->liga;
            $busqueda = array_search($codigoUnico, array_column($grupoJuegos, 'codigo'));
            if ($busqueda !== false ) {
                $grupoJuegos[$busqueda]["equipo2"] = $value->equipo;
                $grupoJuegos[$busqueda]["result2"] = $value->resultado;
            }else{
                $grupoJuegos[] = [
                    "codigo"  => $codigoUnico,
                    "equipo1" => $value->equipo,
                    "equipo2" => "",
                    "result1" => $value->resultado,
                    "result2" => "",
                ];
            }
        }

        foreach ($grupoJuegos as $key => $value) {
            $jjE1 = 0;
            $jjE2 = 0;
            $jgE1 = 0;
            $jgE2 = 0;
            $jeE1 = 0;
            $jeE2 = 0;
            $jpE1 = 0;
            $jpE2 = 0;
            $sE1  = 0;
            $sE2  = 0;
            $gfE1  = 0;
            $gcE1  = 0;
            $gfE2  = 0;
            $gcE2  = 0;

            if ( ($value["result1"] >= 0) && ($value["result2"] >= 0) ) {
                $jjE1 = 1;
                $jjE2 = 1;
                if ($value["result1"] > $value["result2"]) {
                    $jgE1  = 1;
                    $jpE2  = 1;
                    $sE1   = 3;
                    $gfE1  = $value["result1"];
                    $gcE1  = $value["result2"];
                    $gfE2  = $value["result2"];
                    $gcE2  = $value["result1"];
                }elseif ($value["result1"] < $value["result2"]) {
                    $jgE2  = 1;
                    $jpE1  = 1;
                    $sE2   = 3;
                    $gfE1  = $value["result1"];
                    $gcE1  = $value["result2"];
                    $gfE2  = $value["result2"];
                    $gcE2  = $value["result1"];
                }elseif ($value["result1"] == $value["result2"]){
                    $jeE1  = 1;
                    $jeE2  = 1;
                    $sE1   = 1;
                    $sE2   = 1;
                    $gfE1  = $value["result1"];
                    $gcE1  = $value["result2"];
                    $gfE2  = $value["result2"];
                    $gcE2  = $value["result1"];
                }
            }

            $busqueda2 = array_search($value["equipo1"], array_column($resultado, 'equipo'));
            $busqueda3 = array_search($value["equipo2"], array_column($resultado, 'equipo'));

            if ($busqueda2 !== false) {
                //equipo 1
                $resultado[$busqueda2]["jj"]   = $resultado[$busqueda2]["jj"] + $jjE1;
                $resultado[$busqueda2]["jg"]   = $resultado[$busqueda2]["jg"] + $jgE1;
                $resultado[$busqueda2]["je"]   = $resultado[$busqueda2]["je"] + $jeE1;
                $resultado[$busqueda2]["jp"]   = $resultado[$busqueda2]["jp"] + $jpE1;
                $resultado[$busqueda2]["suma"] = $resultado[$busqueda2]["suma"] + $sE1;
                $resultado[$busqueda2]["gf"]   = $resultado[$busqueda2]["gf"] + $gfE1;
                $resultado[$busqueda2]["gc"]   = $resultado[$busqueda2]["gc"] + $gcE1;
            }else{
                //equipo 1
                $resultado[] = [
                    "equipo" => $value["equipo1"],
                    "jj"     => $jjE1,
                    "jg"     => $jgE1,
                    "je"     => $jeE1,
                    "jp"     => $jpE1,
                    "gf"     => $gfE1,
                    "gc"     => $gcE1,
                    "suma"   => $sE1
                ];
            }

            if ($busqueda3 !== false) {
                //equipo 2
                $resultado[$busqueda3]["jj"]   = $resultado[$busqueda3]["jj"] + $jjE2;
                $resultado[$busqueda3]["jg"]   = $resultado[$busqueda3]["jg"] + $jgE2;
                $resultado[$busqueda3]["je"]   = $resultado[$busqueda3]["je"] + $jeE2;
                $resultado[$busqueda3]["jp"]   = $resultado[$busqueda3]["jp"] + $jpE2;
                $resultado[$busqueda3]["suma"] = $resultado[$busqueda3]["suma"] + $sE2;
                $resultado[$busqueda3]["gf"]   = $resultado[$busqueda3]["gf"] + $gfE2;
                $resultado[$busqueda3]["gc"]   = $resultado[$busqueda3]["gc"] + $gcE2;
            }else{
                $resultado[] = [
                    "equipo" => $value["equipo2"],
                    "jj"     => $jjE2,
                    "jg"     => $jgE2,
                    "je"     => $jeE2,
                    "jp"     => $jpE2,
                    "suma"   => $sE2,
                    "gf"     => $gfE2,
                    "gc"     => $gcE2,
                ];
            }
        }

        foreach ($resultado as $key => $value) {
            Posicion::cargaApi($value["equipo"], $value);
        }
    }
}
